import { jsxs, Fragment, jsx } from "react/jsx-runtime";
import { D as DeleteModal } from "./delete-modal-CTUf4WRn.js";
import { T as TableFilter } from "./table-filter-BKvPriu7.js";
import { T as TableFooter } from "./table-footer-Cfva3_5Y.js";
import { A as Accordion, a as AccordionItem, b as AccordionTrigger, c as AccordionContent } from "./accordion-DjZKTuzo.js";
import { B as Button } from "./button-CoRGprmX.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { D as DashboardLayout } from "./layout-Coo-00Zo.js";
import { Plus, Trash2, Pencil } from "lucide-react";
import { Renderer } from "richtor";
/* empty css                 */
import NewsletterForm from "./newsletter-form-B4DZy26P.js";
import NewsletterSend from "./newsletter-send-C4dAmBYa.js";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "@inertiajs/react";
import "react";
import "./use-lang-44ndmTOc.js";
import "./debounce-ZFxqVthq.js";
import "./route-DlE7FdTW.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./table-page-size-CjbVFJnO.js";
import "@radix-ui/react-accordion";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./sidebar-4chFkdEZ.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./app-logo-CP8LgHIG.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./input-BPdrsFAc.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./inertia-BtwbgBI3.js";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
const Index = ({ newsletters, translate }) => {
  const { dashboard, button } = translate;
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs("div", { className: "relative flex items-center justify-between gap-4 pb-6", children: [
      /* @__PURE__ */ jsx(
        TableFilter,
        {
          data: newsletters,
          title: dashboard.newsletter_list,
          globalSearch: true,
          tablePageSizes: [10, 15, 20, 25],
          routeName: "newsletters.index",
          className: "w-full !p-0 md:p-0"
        }
      ),
      /* @__PURE__ */ jsx(
        NewsletterForm,
        {
          title: button.add_newsletter,
          handler: /* @__PURE__ */ jsxs(Button, { variant: "outline", className: "absolute -top-1 right-0 md:static md:mb-1", children: [
            /* @__PURE__ */ jsx(Plus, {}),
            /* @__PURE__ */ jsx("span", { children: button.add_newsletter })
          ] })
        }
      )
    ] }),
    /* @__PURE__ */ jsx(Card, { className: "flex flex-col divide-y p-4", children: /* @__PURE__ */ jsx(Accordion, { type: "single", collapsible: true, className: "space-y-4", children: newsletters.data.length > 0 ? newsletters.data.map((newsletter, index) => /* @__PURE__ */ jsxs(AccordionItem, { value: newsletter.id, className: "w-full overflow-hidden rounded-lg border", children: [
      /* @__PURE__ */ jsx(AccordionTrigger, { className: "[&[data-state=open]]:!bg-muted px-4 py-3 text-base hover:no-underline", children: /* @__PURE__ */ jsxs("div", { className: "flex w-full items-center justify-between pr-4", children: [
        /* @__PURE__ */ jsxs("span", { children: [
          newsletters.total - index,
          ". ",
          newsletter.subject
        ] }),
        /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", onClick: (e) => e.stopPropagation(), children: [
          /* @__PURE__ */ jsx(
            DeleteModal,
            {
              routePath: route("newsletters.destroy", {
                id: newsletter.id
              }),
              actionComponent: /* @__PURE__ */ jsx(Button, { size: "icon", variant: "secondary", className: "text-destructive h-7 w-7", children: /* @__PURE__ */ jsx(Trash2, { className: "h-3 w-3" }) })
            }
          ),
          /* @__PURE__ */ jsx(NewsletterSend, { id: newsletter.id }),
          /* @__PURE__ */ jsx(
            NewsletterForm,
            {
              title: button.update_newsletter,
              newsletter,
              handler: /* @__PURE__ */ jsx(Button, { size: "icon", variant: "secondary", className: "h-7 w-7", children: /* @__PURE__ */ jsx(Pencil, { className: "h-3 w-3" }) })
            }
          )
        ] })
      ] }) }),
      /* @__PURE__ */ jsx(AccordionContent, { className: "space-y-2 p-4", children: /* @__PURE__ */ jsx(Renderer, { value: newsletter.description }) })
    ] }, newsletter.id)) : /* @__PURE__ */ jsx("p", { className: "text-muted-foreground p-6 text-center text-sm", children: dashboard.no_newsletters_found }) }) }),
    /* @__PURE__ */ jsx(TableFooter, { className: "mt-1 p-5 sm:p-7", routeName: "newsletters.index", paginationInfo: newsletters })
  ] });
};
Index.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Index as default
};
